import 'package:flutter/material.dart';

class SlidingAppBar extends StatelessWidget implements PreferredSizeWidget {
  SlidingAppBar({
    this.child,
    this.controller,
    this.visible,
  });

  final PreferredSizeWidget? child;
  final AnimationController? controller;
  final bool? visible;

  @override
  Size get preferredSize => child!.preferredSize;

  @override
  Widget build(BuildContext context) {
    visible! ? controller!.reverse() : controller!.forward();
    return SlideTransition(
      position: Tween<Offset>(begin: Offset.zero, end: Offset(0, -1)).animate(
        CurvedAnimation(parent: controller!, curve: Curves.fastOutSlowIn),
      ),
      child: child,
    );
  }
}
